(*| 13:29 14/10/1993 *)
UNIT EGAVARS;

INTERFACE

USES
  Crt,StdTypes;

CONST
  MaxCellByte=7;
  MaxCharNum=255;
  MaxFontFileSize=256*32;

  Mask: ARRAY[0..MaxCellByte] OF Byte = ($80,$40,$20,$10,$08,$04,$02,$01);

  MainForeGround=White;
  MainBackGround=Blue;

TYPE
  MicroCellType  = ARRAY[0..MaxCellByte] OF BYTE;
  BytePointer = ^Byte;
  FontCharPtrsType = ARRAY[0..MaxCharNum] OF BytePointer;

VAR
  BlankMicroCell : MicroCellType;
  FontCharPtrs,Font1CharPtrs,Font2CharPtrs : FontCharPtrsType;
  FontFile : FILE;
  FontFileName,Font1FileName,Font2FileName : LineString;
  FontFileSize,Font1FileSize,Font2FileSize : LongInt;
  FontBuffer,Font1Buffer,Font2Buffer : BytePointer;
  BytesPerChar,Font1Height,Font2Height : Integer;
  MonoCrt: Boolean;
  SetX,SetY: Integer;
  FontUpdated,Font1Updated,Font2Updated: Boolean;
  FontNumber: Integer;
  ProgramTitle: LineString;

IMPLEMENTATION

VAR
  I: Integer;
BEGIN
  GetMem(Font1Buffer,MaxFontFileSize);
  GetMem(Font2Buffer,MaxFontFileSize);
  FontBuffer := Font1Buffer;
  FOR I:=0 TO MaxCellByte DO
    BlankMicroCell[I]:=0;
  FOR I:=0 TO MaxCharNum DO
    FontCharPtrs[I]:=nil;
  Font1CharPtrs:=FontCharPtrs;
  Font2CharPtrs:=FontCharPtrs;
  SetX:=0;
  SetY:=1;
  FontFileName:= '';
  Font1FileName:= '';
  Font2FileName:= '';
  FontUpdated:=False;
  Font1Updated:=False;
  Font2Updated:=False;
  FontNumber:= 0;
END.
